/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import marauroa.common.ConfigurationParams;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.io.Persistence;

public class Configuration {
    private static final Logger logger = Log4J.getLogger(Configuration.class);
    private static ConfigurationParams staticParams = new ConfigurationParams();
    private static Configuration configuration = null;
    private final ConfigurationParams params;
    private final Properties properties;

    public static void setConfigurationFile(String string) {
        staticParams.setRelativeToHome(false);
        staticParams.setBasedir("");
        staticParams.setConfigurationFile(string);
    }

    public static void setConfigurationFile(boolean bl, String string, String string2) {
        staticParams.setRelativeToHome(bl);
        staticParams.setBasedir(string);
        staticParams.setConfigurationFile(string2);
    }

    public static void setConfigurationPersitance(boolean bl) {
        staticParams.setPersistence(bl);
    }

    public static String getConfigurationFile() {
        return staticParams.getConfigurationFile();
    }

    public Configuration(ConfigurationParams configurationParams) throws IOException {
        this.params = configurationParams;
        try {
            this.properties = new Properties();
            if (configurationParams.isPersistence()) {
                InputStream inputStream = Persistence.get().getInputStream(configurationParams.isRelativeToHome(), configurationParams.getBasedir(), configurationParams.getConfigurationFile());
                this.properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.warn("Configuration file not found: " + configurationParams.getConfigurationFile(), fileNotFoundException);
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            logger.warn("Error loading Configuration file", iOException);
            throw iOException;
        }
    }

    public static Configuration getConfiguration() throws IOException {
        if (configuration == null) {
            configuration = new Configuration(staticParams);
        }
        return configuration;
    }

    public String get(String string) {
        String string2 = this.properties.getProperty(string);
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    public String get(String string, String string2) {
        String string3 = this.properties.getProperty(string, string2);
        if (string3 != null) {
            string3 = string3.trim();
        }
        return string3;
    }

    public int getInt(String string, int n) {
        int n2 = n;
        String string2 = this.properties.getProperty(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2.trim());
            }
            catch (NumberFormatException numberFormatException) {
                logger.error("Configuration parameter " + string + " is \"" + string2 + "\" but an int was expected.");
            }
        }
        return n2;
    }

    public boolean has(String string) {
        return this.properties.containsKey(string);
    }

    public void set(String string, String string2) {
        try {
            this.properties.put(string, string2);
            if (this.params.isPersistence()) {
                OutputStream outputStream = Persistence.get().getOutputStream(this.params.isRelativeToHome(), this.params.getBasedir(), this.params.getConfigurationFile());
                this.properties.store(outputStream, null);
                outputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error("Configuration file not found: " + this.params.isRelativeToHome() + " " + this.params.getBasedir() + " " + this.params.getConfigurationFile(), fileNotFoundException);
        }
        catch (IOException iOException) {
            logger.error("Error storing Configuration file", iOException);
        }
    }

    public Enumeration<?> propertyNames() {
        return this.properties.propertyNames();
    }

    public void clear() {
        this.properties.clear();
    }

    public Properties getAsProperties() {
        return (Properties)this.properties.clone();
    }
}

