/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.game;

import java.io.IOException;
import marauroa.common.game.Definition;
import marauroa.common.game.DetailLevel;
import marauroa.common.game.RPClass;
import marauroa.common.game.RPObject;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.Serializable;

public class RPLink
implements Serializable,
Cloneable {
    private String name;
    private RPObject object;
    private RPObject owner;

    public RPLink(String string, RPObject rPObject) {
        this.name = string;
        this.object = rPObject;
        this.owner = null;
    }

    void setOwner(RPObject rPObject) {
        this.owner = rPObject;
    }

    RPObject getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public void setObject(RPObject rPObject) {
        this.object = rPObject;
    }

    public RPObject getObject() {
        return this.object;
    }

    public Object clone() {
        RPLink rPLink = null;
        try {
            rPLink = (RPLink)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        rPLink.object = (RPObject)this.object.clone();
        return rPLink;
    }

    public String toString() {
        return "name: " + this.name + " --> " + this.object;
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        this.writeObject(outputSerializer, DetailLevel.NORMAL);
    }

    public void writeObject(OutputSerializer outputSerializer, DetailLevel detailLevel) throws IOException {
        RPClass rPClass = this.owner.getRPClass();
        Definition definition = rPClass.getDefinition(Definition.DefinitionClass.RPLINK, this.name);
        short s = definition.getCode();
        if (detailLevel == DetailLevel.FULL) {
            s = -1;
        }
        outputSerializer.write(s);
        if (s == -1) {
            outputSerializer.write(this.name);
        }
        outputSerializer.write(this.object);
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        short s = inputSerializer.readShort();
        if (s == -1) {
            this.name = inputSerializer.readString();
        } else {
            RPClass rPClass = this.owner.getRPClass();
            this.name = rPClass.getName(Definition.DefinitionClass.RPLINK, s);
        }
        this.object = (RPObject)inputSerializer.readObject(new RPObject());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof RPLink) {
            RPLink rPLink = (RPLink)object;
            return this.name.equals(rPLink.name) && this.object.equals(rPLink.object);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

