/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import marauroa.common.Log4J;
import marauroa.common.Logger;

public class I18N {
    private static final Logger logger = Log4J.getLogger(I18N.class);
    private static ThreadLocal<Locale> threadLocale = new ThreadLocal();
    private static Map<String, Map<String, String>> dictionaries = new HashMap<String, Map<String, String>>();
    private static Locale defaultLocale = Locale.ENGLISH;

    public static void init(Locale locale) {
        defaultLocale = locale;
    }

    public static void addDictionaryFolder(String string) {
        for (String string2 : Locale.getISOLanguages()) {
            InputStream inputStream = I18N.class.getClassLoader().getResourceAsStream(string + "/" + string2 + ".txt");
            if (inputStream == null) continue;
            Map<String, String> map = dictionaries.get(string2);
            if (map == null) {
                map = new HashMap<String, String>();
                dictionaries.put(string2, map);
            }
            I18N.readFile(inputStream, map);
        }
    }

    private static void readFile(InputStream inputStream, Map<String, String> map) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            String string = bufferedReader.readLine();
            while (string != null) {
                int n = string.indexOf("=");
                if (n > -1) {
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    map.put(string2, string3);
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                logger.error(iOException, iOException);
            }
        }
    }

    public static void setThreadLocale(Locale locale) {
        threadLocale.set(locale);
    }

    public static void resetThreadLocale() {
        threadLocale.set(defaultLocale);
    }

    public static Locale getLocale() {
        Locale locale = threadLocale.get();
        if (locale == null) {
            locale = defaultLocale;
        }
        return locale;
    }

    public static String translate(String string, Object ... objectArray) {
        Locale locale = I18N.getLocale();
        String string2 = null;
        Map<String, String> map = dictionaries.get(locale.getLanguage());
        if (map != null) {
            string2 = map.get(string);
        }
        if (string2 == null) {
            string2 = string;
        }
        return String.format(locale, string2, objectArray);
    }

    static {
        I18N.addDictionaryFolder(I18N.class.getPackage().getName().replace('.', '/'));
    }
}

