/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class UnicodeSupportingInputStream
extends InputStream {
    private PushbackInputStream internalIn;
    private boolean isInited = false;
    private String defaultEnc;
    private String encoding;
    private static final int BOM_SIZE = 4;

    public UnicodeSupportingInputStream(InputStream inputStream) {
        this.internalIn = new PushbackInputStream(inputStream, 4);
    }

    public UnicodeSupportingInputStream(InputStream inputStream, String string) {
        this.internalIn = new PushbackInputStream(inputStream, 4);
        this.defaultEnc = string;
    }

    public String getDefaultEncoding() {
        return this.defaultEnc;
    }

    public String getEncoding() {
        if (!this.isInited) {
            try {
                this.init();
            }
            catch (IOException iOException) {
                IllegalStateException illegalStateException = new IllegalStateException("Init method failed.");
                illegalStateException.initCause(iOException);
                throw illegalStateException;
            }
        }
        return this.encoding;
    }

    protected void init() throws IOException {
        int n;
        if (this.isInited) {
            return;
        }
        byte[] byArray = new byte[4];
        int n2 = this.internalIn.read(byArray, 0, byArray.length);
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            this.encoding = "UTF-32BE";
            n = n2 - 4;
        } else if (byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            this.encoding = "UTF-32LE";
            n = n2 - 4;
        } else if (byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            this.encoding = "UTF-8";
            n = n2 - 3;
        } else if (byArray[0] == -2 && byArray[1] == -1) {
            this.encoding = "UTF-16BE";
            n = n2 - 2;
        } else if (byArray[0] == -1 && byArray[1] == -2) {
            this.encoding = "UTF-16LE";
            n = n2 - 2;
        } else {
            this.encoding = this.defaultEnc;
            n = n2;
        }
        if (n > 0) {
            this.internalIn.unread(byArray, n2 - n, n);
        }
        this.isInited = true;
    }

    @Override
    public void close() throws IOException {
        this.isInited = true;
        this.internalIn.close();
    }

    @Override
    public int read() throws IOException {
        this.isInited = true;
        return this.internalIn.read();
    }
}

