/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import marauroa.common.Utility;
import marauroa.common.crypto.Hash;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageSendByteArray;

public class MessageC2SLoginSendNonceNameAndPassword
extends MessageSendByteArray {
    private String username;
    private byte[] password;

    public MessageC2SLoginSendNonceNameAndPassword() {
        super(Message.MessageType.C2S_LOGIN_SENDNONCENAMEANDPASSWORD);
    }

    public MessageC2SLoginSendNonceNameAndPassword(Channel channel, byte[] byArray, String string, byte[] byArray2) {
        super(Message.MessageType.C2S_LOGIN_SENDNONCENAMEANDPASSWORD, channel, byArray);
        this.username = string;
        this.password = Utility.copy(byArray2);
    }

    public String getUsername() {
        return this.username;
    }

    public byte[] getPassword() {
        return Utility.copy(this.password);
    }

    @Override
    public String toString() {
        return "Message (C2S Login) from (" + this.getAddress() + ") CONTENTS: (nonce:" + Hash.toHexString(this.hash) + "\tusername:" + this.username + ")";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write(this.username);
        outputSerializer.write(this.password);
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        this.username = inputSerializer.readString();
        this.password = inputSerializer.readByteArray();
        if (this.type != Message.MessageType.C2S_LOGIN_SENDNONCENAMEANDPASSWORD) {
            throw new IOException();
        }
    }
}

