/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import java.util.Map;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;
import org.apache.log4j.Logger;

public class MessageC2SLogout
extends Message {
    private static Logger logger = Logger.getLogger(MessageC2SLogout.class);
    private int reason = 0;

    public MessageC2SLogout() {
        super(Message.MessageType.C2S_LOGOUT, null);
    }

    public MessageC2SLogout(int n) {
        super(Message.MessageType.C2S_LOGOUT, null);
        this.reason = n;
    }

    public MessageC2SLogout(Channel channel) {
        super(Message.MessageType.C2S_LOGOUT, channel);
    }

    public int getReason() {
        return this.reason;
    }

    @Override
    public String toString() {
        return "Message (C2S Logout) from (" + this.getAddress() + ") CONTENTS: ()";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        if (this.reason != 0) {
            outputSerializer.write(this.reason);
        }
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        if (this.type != Message.MessageType.C2S_LOGOUT) {
            throw new IOException();
        }
        if (inputSerializer.available() >= 4) {
            this.reason = inputSerializer.readInt();
        }
    }

    @Override
    public void readFromMap(Map<String, Object> map) throws IOException {
        super.readFromMap(map);
        Object object = map.get("reason");
        try {
            if (object != null) {
                this.reason = Integer.parseInt(object.toString());
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.warn((Object)numberFormatException, (Throwable)numberFormatException);
        }
        if (this.type != Message.MessageType.C2S_LOGOUT) {
            throw new IOException();
        }
    }
}

