/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.TransferContent;

public class MessageC2STransferACK
extends Message {
    private List<TransferContent> contents;

    public MessageC2STransferACK() {
        super(Message.MessageType.C2S_TRANSFER_ACK, null);
    }

    public MessageC2STransferACK(Channel channel, List<TransferContent> list) {
        super(Message.MessageType.C2S_TRANSFER_ACK, channel);
        this.contents = list;
    }

    public List<TransferContent> getContents() {
        return this.contents;
    }

    @Override
    public String toString() {
        return "Message (C2S Transfer ACK) from (" + this.getAddress() + ") CONTENTS: (" + this.contents.size() + ")";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        int n = this.contents.size();
        outputSerializer.write(n);
        for (TransferContent transferContent : this.contents) {
            transferContent.writeACK(outputSerializer);
        }
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        int n = inputSerializer.readInt();
        this.contents = new LinkedList<TransferContent>();
        for (int i = 0; i < n; ++i) {
            TransferContent transferContent = new TransferContent();
            transferContent.readACK(inputSerializer);
            this.contents.add(transferContent);
        }
        if (this.type != Message.MessageType.C2S_TRANSFER_ACK) {
            throw new IOException();
        }
    }

    @Override
    public void readFromMap(Map<String, Object> map) throws IOException {
        super.readFromMap(map);
        this.contents = new LinkedList<TransferContent>();
        Map map2 = (Map)map.get("contents");
        for (Map.Entry entry : map2.entrySet()) {
            TransferContent transferContent = new TransferContent();
            transferContent.readACKFromMap((String)entry.getKey(), entry.getValue());
            this.contents.add(transferContent);
        }
        if (this.type != Message.MessageType.C2S_TRANSFER_ACK) {
            throw new IOException();
        }
    }

    @Override
    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",\"contents\":{");
        boolean bl = true;
        for (TransferContent transferContent : this.contents) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(",");
            }
            transferContent.writeACKToJson(stringBuilder);
        }
        stringBuilder.append("}");
    }
}

