/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.net.message;

import java.io.IOException;
import marauroa.common.i18n.I18N;
import marauroa.common.net.Channel;
import marauroa.common.net.InputSerializer;
import marauroa.common.net.OutputSerializer;
import marauroa.common.net.message.Message;

public class MessageS2CLoginNACK
extends Message {
    private static String[] text = new String[]{"Niepoprawna nazwa u\u017cytkownika/has\u0142a. ", "Wyst\u0105pi\u0142o zbyt wiele niepoprawnych pr\u00f3b zalogowania do twojego konta lub z twojej sieci. Odczekaj kilka minut lub skontaktuj si\u0119 ze wsparciem.", "Konto jest zablokowane.", "Serwer jest pe\u0142ny.", "Serwer dzia\u0142a na niekompatybilnej wersji gry. Zaktualizuj.", "Nieprawid\u0142owa wersja protoko\u0142u.", "Hash, kt\u00f3ry wysy\u0142asz jest nie zgodny z tym co wys\u0142a\u0142e\u015b wcze\u015bniej.", "Twoje konto jest nieaktywne. Musisz potwierdzi\u0107 utworzenie konta klikaj\u0105c na odno\u015bnik przes\u0142any w e-mailu. Je\u015bli go nie otrzyma\u0142e\u015b to zaloguj si\u0119 na stronie i naci\u015bnij na przycisk ponownego wys\u0142ania lub skontaktuj si\u0119 ze wsparciem. Masz 24 godziny na potwierdzenie utworzenia konta poniewa\u017c po tym czasie konto zostanie automatycznie usuni\u0119te.", "Wyst\u0105pi\u0142o zbyt wiele nieudanych pr\u00f3b zalogowania do twojego konta. Odczekaj kilka minut lub skontaktuj si\u0119 ze wsparciem.", "Wyst\u0105pi\u0142o zbyt wiele nieudanych pr\u00f3b zalogowania z twojej sieci. Odczekaj kilka minut lub skontaktuj si\u0119 ze wsparciem.", "Nie powiod\u0142o si\u0119 wst\u0119pne uwierzytelnienie. Spr\u00f3buj ponownie.", "To konto zosta\u0142o po\u0142\u0105czone z innym kontem. U\u017cyj loginu innego konta, aby zalogowa\u0107 lub skontaktuj si\u0119 ze wsparciem."};
    private Reasons reason;

    public MessageS2CLoginNACK() {
        super(Message.MessageType.S2C_LOGIN_NACK, null);
    }

    public MessageS2CLoginNACK(Channel channel, Reasons reasons) {
        super(Message.MessageType.S2C_LOGIN_NACK, channel);
        this.reason = reasons;
    }

    public Reasons getResolutionCode() {
        return this.reason;
    }

    public String getResolution() {
        return I18N.translate(text[this.reason.ordinal()], new Object[0]);
    }

    @Override
    public String toString() {
        return "Message (S2C Login NACK) from (" + this.getAddress() + ") CONTENTS: (" + this.getResolution() + ")";
    }

    @Override
    public void writeObject(OutputSerializer outputSerializer) throws IOException {
        super.writeObject(outputSerializer);
        outputSerializer.write((byte)this.reason.ordinal());
    }

    @Override
    public void readObject(InputSerializer inputSerializer) throws IOException {
        super.readObject(inputSerializer);
        this.reason = Reasons.values()[inputSerializer.readByte()];
        if (this.type != Message.MessageType.S2C_LOGIN_NACK) {
            throw new IOException();
        }
    }

    @Override
    public void writeToJson(StringBuilder stringBuilder) {
        super.writeToJson(stringBuilder);
        stringBuilder.append(",\"reason\":\"");
        stringBuilder.append(this.reason.name());
        stringBuilder.append("\",\"text\":");
        OutputSerializer.writeJson(stringBuilder, text[this.reason.ordinal()]);
    }

    public static enum Reasons {
        USERNAME_WRONG,
        TOO_MANY_TRIES,
        USERNAME_BANNED,
        SERVER_IS_FULL,
        GAME_MISMATCH,
        PROTOCOL_MISMATCH,
        INVALID_NONCE,
        USERNAME_INACTIVE,
        TOO_MANY_TRIES_USERNAME,
        TOO_MANY_TRIES_IP,
        SEED_WRONG,
        ACCOUNT_MERGED;

    }
}

