/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.resource;

import java.io.IOException;
import java.io.InputStream;
import marauroa.common.resource.ResourceProvider;

public class ClassPathResourceProvider
implements ResourceProvider {
    private final ClassLoader classLoader;

    public ClassPathResourceProvider(ClassLoader classLoader) {
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader2 == null) {
            classLoader2 = ClassLoader.getSystemClassLoader();
        }
        this.classLoader = classLoader2;
    }

    @Override
    public InputStream open(String string) throws IOException {
        InputStream inputStream = this.classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("Unable to locate resource '" + string + "' on the classpath");
        }
        return inputStream;
    }
}

