/*
 * Decompiled with CFR 0.152.
 */
package marauroa.common.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.resource.ClassPathResourceProvider;
import marauroa.common.resource.Reloadable;
import marauroa.common.resource.ResourceProvider;

public final class ResourceReloadService {
    private static final Logger logger = Log4J.getLogger(ResourceReloadService.class);
    private static final ResourceReloadService INSTANCE = new ResourceReloadService();
    private final Set<Reloadable> registered = ResourceReloadService.createSet();
    private final Set<Reloadable> queued = ResourceReloadService.createSet();
    private final Queue<Reloadable> queue = new ConcurrentLinkedQueue<Reloadable>();
    private volatile ResourceProvider provider = new ClassPathResourceProvider(Thread.currentThread().getContextClassLoader());

    private ResourceReloadService() {
    }

    private static Set<Reloadable> createSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public static ResourceReloadService getInstance() {
        return INSTANCE;
    }

    public void setResourceProvider(ResourceProvider resourceProvider) {
        if (resourceProvider == null) {
            throw new IllegalArgumentException("provider must not be null");
        }
        this.provider = resourceProvider;
    }

    public void register(Reloadable reloadable) {
        if (reloadable == null) {
            throw new IllegalArgumentException("reloadable must not be null");
        }
        this.registered.add(reloadable);
    }

    public void registerAll(Collection<? extends Reloadable> collection) {
        if (collection == null) {
            return;
        }
        for (Reloadable reloadable : collection) {
            if (reloadable == null) continue;
            this.register(reloadable);
        }
    }

    public void unregister(Reloadable reloadable) {
        if (reloadable == null) {
            return;
        }
        this.registered.remove(reloadable);
        this.queued.remove(reloadable);
        this.queue.remove(reloadable);
    }

    public void requestReload(Reloadable reloadable) {
        if (reloadable == null) {
            return;
        }
        if (this.queued.add(reloadable)) {
            this.queue.add(reloadable);
        }
    }

    public void requestReloadAll() {
        for (Reloadable reloadable : this.registered) {
            this.requestReload(reloadable);
        }
    }

    public void processPendingReloads() {
        Reloadable reloadable;
        while ((reloadable = this.queue.poll()) != null) {
            this.queued.remove(reloadable);
            try {
                this.reload(reloadable);
            }
            catch (Exception exception) {
                logger.error("Failed to reload resource '" + ResourceReloadService.safePath(reloadable) + "'", exception);
            }
        }
    }

    private void reload(Reloadable reloadable) throws Exception {
        reloadable.reload(this.provider);
        logger.info("Reloaded resource '" + ResourceReloadService.safePath(reloadable) + "'");
    }

    private static String safePath(Reloadable reloadable) {
        try {
            String string = reloadable.resourcePath();
            return string != null ? string : "<unknown>";
        }
        catch (Exception exception) {
            return "<error>";
        }
    }
}

