/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.Pair;
import marauroa.common.Utility;
import marauroa.server.db.AdapterFactory;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.adapter.DatabaseAdapter;

public class TransactionPool {
    private static Logger logger = Log4J.getLogger(TransactionPool.class);
    private static TransactionPool dbtransactionPool = null;
    private AdapterFactory factory = null;
    private final Object wait = new Object();
    private Properties params = new Properties();
    private int count = 10;
    private final List<DBTransaction> dbtransactions = Collections.synchronizedList(new LinkedList());
    private final List<DBTransaction> freeDBTransactions = Collections.synchronizedList(new LinkedList());
    private final ThreadLocal<Set<DBTransaction>> threadTransactions = new ThreadLocal();
    private final Map<DBTransaction, Pair<String, StackTraceElement[]>> callers;
    private boolean closed = false;

    public TransactionPool(Properties properties) {
        this.params = properties;
        this.count = Integer.parseInt(this.params.getProperty("count", "4"));
        this.callers = Collections.synchronizedMap(new HashMap());
        this.factory = new AdapterFactory(properties);
    }

    public void registerGlobally() {
        TransactionPool.registerGlobal(this);
    }

    private static void registerGlobal(TransactionPool transactionPool) {
        dbtransactionPool = transactionPool;
    }

    public static synchronized TransactionPool get() {
        return dbtransactionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMinimumDBTransactions() {
        Object object = this.wait;
        synchronized (object) {
            while (this.dbtransactions.size() < this.count) {
                DatabaseAdapter databaseAdapter = this.factory.create();
                if (databaseAdapter == null) {
                    Utility.sleep(1000);
                    continue;
                }
                DBTransaction dBTransaction = new DBTransaction(databaseAdapter);
                this.dbtransactions.add(dBTransaction);
                this.freeDBTransactions.add(dBTransaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBTransaction beginWork() {
        Object object;
        if (this.closed) {
            throw new RuntimeException("transaction pool has been closed");
        }
        DBTransaction dBTransaction = null;
        while (dBTransaction == null) {
            object = this.wait;
            synchronized (object) {
                this.createMinimumDBTransactions();
                if (this.freeDBTransactions.size() == 0) {
                    try {
                        logger.info("Waiting for a DBTransaction", new Throwable());
                        this.dumpOpenTransactions();
                        this.wait.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error(interruptedException, interruptedException);
                    }
                } else {
                    dBTransaction = this.freeDBTransactions.remove(0);
                    this.addThreadTransaction(dBTransaction);
                }
            }
        }
        logger.debug("getDBTransaction: " + dBTransaction, new Throwable());
        object = Thread.currentThread();
        this.callers.put(dBTransaction, new Pair<String, StackTraceElement[]>(((Thread)object).getName(), ((Thread)object).getStackTrace()));
        dBTransaction.setThread(Thread.currentThread());
        return dBTransaction;
    }

    public void dumpOpenTransactions() {
        for (Pair<String, StackTraceElement[]> pair : this.callers.values()) {
            logger.warn("      * " + pair.first() + " " + Arrays.asList(pair.second()));
        }
    }

    public void commit(DBTransaction dBTransaction) throws SQLException {
        try {
            dBTransaction.commit();
        }
        catch (SQLException sQLException) {
            this.killTransaction(dBTransaction);
            throw sQLException;
        }
        this.freeDBTransaction(dBTransaction);
    }

    public void rollback(DBTransaction dBTransaction) {
        try {
            dBTransaction.rollback();
            this.freeDBTransaction(dBTransaction);
        }
        catch (SQLException sQLException) {
            this.killTransaction(dBTransaction);
            logger.warn(sQLException, sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeDBTransaction(DBTransaction dBTransaction) {
        logger.debug("freeDBTransaction: " + dBTransaction, new Throwable());
        Object object = this.wait;
        synchronized (object) {
            this.threadTransactions.get().remove(dBTransaction);
            this.callers.remove(dBTransaction);
            dBTransaction.setThread(null);
            if (this.dbtransactions.contains(dBTransaction)) {
                this.freeDBTransactions.add(dBTransaction);
            } else {
                logger.error("Unknown DBTransaction " + dBTransaction + " was not freed.", new Throwable());
            }
            this.wait.notifyAll();
        }
    }

    private void addThreadTransaction(DBTransaction dBTransaction) {
        Set<DBTransaction> set = this.threadTransactions.get();
        if (set == null) {
            set = new HashSet<DBTransaction>();
            this.threadTransactions.set(set);
        }
        set.add(dBTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kickHangingTransactionsOfThisThread() {
        Set<DBTransaction> set = this.threadTransactions.get();
        if (set == null || set.isEmpty()) {
            return;
        }
        Object object = this.wait;
        synchronized (object) {
            for (DBTransaction dBTransaction : set) {
                this.killTransaction(dBTransaction);
                logger.error("Hanging transaction " + dBTransaction + " was kicked.");
            }
            this.wait.notifyAll();
        }
        set.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAvailableTransaction() {
        Object object = this.wait;
        synchronized (object) {
            for (DBTransaction dBTransaction : new HashSet<DBTransaction>(this.freeDBTransactions)) {
                try {
                    dBTransaction.setThread(Thread.currentThread());
                    dBTransaction.querySingleCellInt("SELECT 1", null);
                    dBTransaction.setThread(null);
                }
                catch (SQLException sQLException) {
                    logger.warn("Killing dead transaction " + dBTransaction + ".");
                    this.killTransaction(dBTransaction);
                }
            }
        }
    }

    public void killTransaction(DBTransaction dBTransaction) {
        try {
            dBTransaction.setThread(Thread.currentThread());
            dBTransaction.rollback();
        }
        catch (SQLException sQLException) {
            logger.debug(sQLException, sQLException);
        }
        dBTransaction.close();
        this.dbtransactions.remove(dBTransaction);
        this.freeDBTransactions.remove(dBTransaction);
        this.callers.remove(dBTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyAllAvailableConnections() {
        Object object = this.wait;
        synchronized (object) {
            Iterator<DBTransaction> iterator = this.freeDBTransactions.iterator();
            while (iterator.hasNext()) {
                DBTransaction dBTransaction = iterator.next();
                if (dBTransaction.verifyConnection()) continue;
                this.killTransaction(dBTransaction);
                iterator.remove();
            }
        }
    }

    public void close() {
        this.closed = true;
        for (DBTransaction dBTransaction : this.dbtransactions) {
            dBTransaction.close();
        }
    }
}

