/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db.adapter;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.db.DatabaseConnectionException;
import marauroa.server.db.adapter.AbstractDatabaseAdapter;

public class H2DatabaseAdapter
extends AbstractDatabaseAdapter {
    private static Logger logger = Log4J.getLogger(H2DatabaseAdapter.class);

    public H2DatabaseAdapter(Properties properties) throws DatabaseConnectionException {
        super(properties);
    }

    protected H2DatabaseAdapter() throws DatabaseConnectionException {
    }

    @Override
    protected Connection createConnection(Properties properties) throws SQLException, DatabaseConnectionException {
        Connection connection = super.createConnection(properties);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string = databaseMetaData.getDatabaseProductName();
        if (string.toLowerCase(Locale.ENGLISH).indexOf("h2") < 0) {
            logger.warn("Using H2DatabaseAdapter to connect to " + string, new Throwable());
        }
        if (properties.getProperty("jdbc_url", "").toLowerCase(Locale.ENGLISH).indexOf(";mode=") > -1) {
            logger.warn("The configuration parameter jdbc_url configures H2 for compatibility mode. This is likely to cause trouble.");
        }
        return connection;
    }

    @Override
    protected String rewriteSql(String string) {
        int n;
        String string2 = string.trim();
        String string3 = string2.toLowerCase(Locale.ENGLISH);
        if (string3.startsWith("alter table") && (n = string3.indexOf(" column")) > -1) {
            int n2 = string2.indexOf("(", n);
            int n3 = string2.lastIndexOf(")");
            string2 = string2.substring(0, n + 1) + string2.substring(n2 + 1, n3) + ";";
            string2 = string2.replace(", PRIMARY KEY(id)", "");
        }
        return string2;
    }

    @Override
    public boolean doesTableExist(String string) throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, null, string.toUpperCase(Locale.ENGLISH), null);
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    @Override
    public boolean doesColumnExist(String string, String string2) throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, null, string.toUpperCase(Locale.ENGLISH), string2.toUpperCase(Locale.ENGLISH));
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    @Override
    public int getColumnLength(String string, String string2) throws SQLException {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, null, string.toUpperCase(Locale.ENGLISH), string2.toUpperCase(Locale.ENGLISH));
        if (resultSet.next()) {
            return resultSet.getInt("COLUMN_SIZE");
        }
        return -1;
    }
}

