/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db.command;

import java.io.IOException;
import java.sql.SQLException;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.i18n.I18N;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.TransactionPool;
import marauroa.server.db.command.DBCommandMetaData;
import marauroa.server.db.command.DBCommandQueue;
import marauroa.server.db.command.DBCommandQueueLogger;
import marauroa.server.game.dbcommand.DBCommandWithCallback;
import org.apache.log4j.MDC;

class DBCommandQueueBackgroundThread
implements Runnable {
    private static Logger logger = Log4J.getLogger(DBCommandQueueBackgroundThread.class);
    private DBCommandQueueLogger dbCommandQueueLogger = new DBCommandQueueLogger();
    private long lastWarningTimestamp = 0L;
    private int shutdownCounter = 0;

    DBCommandQueueBackgroundThread() {
    }

    @Override
    public void run() {
        DBCommandQueue dBCommandQueue = DBCommandQueue.get();
        while (true) {
            DBCommandMetaData dBCommandMetaData = null;
            try {
                dBCommandMetaData = dBCommandQueue.getNextCommand();
            }
            catch (InterruptedException interruptedException) {
                logger.error(interruptedException, interruptedException);
            }
            if (dBCommandMetaData != null) {
                try {
                    this.processCommand(dBCommandMetaData);
                }
                catch (RuntimeException runtimeException) {
                    logger.error(runtimeException, runtimeException);
                }
            } else if (dBCommandQueue.isFinished()) {
                ++this.shutdownCounter;
                if (this.shutdownCounter >= 3) break;
            }
            this.checkAndWarnAboutQueueSize(dBCommandQueue);
        }
    }

    private void processCommand(DBCommandMetaData dBCommandMetaData) {
        MDC.put((String)"context", (Object)(dBCommandMetaData + " "));
        if (TransactionPool.get() == null) {
            logger.warn("Database not initialized, skipping database operation");
            return;
        }
        long l = System.currentTimeMillis();
        for (int i = 0; i < 5 && !this.executeDBAction(dBCommandMetaData); ++i) {
            logger.warn("Retrying DBCommand " + dBCommandMetaData);
        }
        long l2 = System.currentTimeMillis();
        if (dBCommandMetaData.getCommand() instanceof DBCommandWithCallback) {
            DBCommandWithCallback dBCommandWithCallback = (DBCommandWithCallback)dBCommandMetaData.getCommand();
            dBCommandWithCallback.invokeCallback();
        }
        long l3 = System.currentTimeMillis();
        this.dbCommandQueueLogger.log(dBCommandMetaData, l, l2, l3);
        if (dBCommandMetaData.isResultAwaited()) {
            dBCommandMetaData.setProcessedTimestamp(System.currentTimeMillis());
            DBCommandQueue.get().addResult(dBCommandMetaData);
        }
        MDC.put((String)"context", (Object)"");
    }

    private boolean executeDBAction(DBCommandMetaData dBCommandMetaData) {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            I18N.setThreadLocale(dBCommandMetaData.getLocale());
            dBCommandMetaData.getCommand().execute(dBTransaction);
            TransactionPool.get().commit(dBTransaction);
        }
        catch (IOException iOException) {
            logger.error(iOException, iOException);
            I18N.resetThreadLocale();
            TransactionPool.get().rollback(dBTransaction);
            dBCommandMetaData.getCommand().setException(iOException);
        }
        catch (SQLException sQLException) {
            logger.error(sQLException, sQLException);
            I18N.resetThreadLocale();
            if (dBTransaction.isDeadlockError(sQLException)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.error(interruptedException);
                }
            }
            if (dBTransaction.isConnectionError(sQLException) || dBTransaction.isDeadlockError(sQLException)) {
                TransactionPool.get().killTransaction(dBTransaction);
                TransactionPool.get().refreshAvailableTransaction();
                return false;
            }
            TransactionPool.get().rollback(dBTransaction);
            dBCommandMetaData.getCommand().setException(sQLException);
        }
        catch (RuntimeException runtimeException) {
            logger.error(runtimeException, runtimeException);
            I18N.resetThreadLocale();
            TransactionPool.get().rollback(dBTransaction);
            dBCommandMetaData.getCommand().setException(runtimeException);
        }
        I18N.resetThreadLocale();
        return true;
    }

    private void checkAndWarnAboutQueueSize(DBCommandQueue dBCommandQueue) {
        long l;
        int n = dBCommandQueue.size();
        if (n > 50 && (l = System.currentTimeMillis()) - this.lastWarningTimestamp > 60000L) {
            logger.warn("DBCommandQueue has " + n + " entries. Oldest entry was enqueued at " + dBCommandQueue.getOldestEnqueueTimestamp());
            this.dbCommandQueueLogger.logQueueSize(dBCommandQueue);
            this.lastWarningTimestamp = l;
        }
    }
}

