/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.db.command;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import marauroa.common.Configuration;
import marauroa.server.db.command.DBCommandMetaData;
import marauroa.server.db.command.DBCommandQueue;
import org.apache.log4j.Logger;

public class DBCommandQueueLogger {
    private static Logger logger = Logger.getLogger(DBCommandQueueLogger.class);
    private BufferedWriter writer = null;
    private static DBCommandQueueLogger instance;

    DBCommandQueueLogger() {
        instance = this;
    }

    public static DBCommandQueueLogger get() {
        return instance;
    }

    void log(DBCommandMetaData dBCommandMetaData, long l, long l2, long l3) {
        if (this.writer != null) {
            this.logInernal(dBCommandMetaData, l, l2, l3);
        }
    }

    synchronized void logInernal(DBCommandMetaData dBCommandMetaData, long l, long l2, long l3) {
        if (this.writer != null) {
            try {
                this.writer.append(l + "\t" + (l2 - l) + "\t" + (l3 - l2) + "\t" + dBCommandMetaData + "\n");
            }
            catch (IOException iOException) {
                logger.error((Object)iOException, (Throwable)iOException);
            }
        }
    }

    public synchronized void stopLogging() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                logger.error((Object)iOException, (Throwable)iOException);
            }
            this.writer = null;
        }
    }

    public synchronized void startLogging(String string) {
        this.stopLogging();
        try {
            this.writer = new BufferedWriter(new FileWriter(string));
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, (Throwable)iOException);
        }
    }

    private String generateLoggingFilename(String string) {
        String string2;
        try {
            string2 = Configuration.getConfiguration().get("logging_folder");
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, (Throwable)iOException);
            return null;
        }
        if (string2 == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss", Locale.ENGLISH);
        String string3 = string2 + "/" + string + "-" + simpleDateFormat.format(new Date()) + ".txt";
        return string3;
    }

    public void logQueueSize(DBCommandQueue dBCommandQueue) {
        String string = this.generateLoggingFilename("large-db-queue");
        if (string == null) {
            return;
        }
        DBCommandMetaData[] dBCommandMetaDataArray = dBCommandQueue.dumpQueue();
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (DBCommandMetaData dBCommandMetaData : dBCommandMetaDataArray) {
                bufferedWriter.append(dBCommandMetaData + "\n");
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, (Throwable)iOException);
        }
    }
}

