/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.db;

import java.util.HashMap;
import java.util.Map;
import marauroa.server.game.db.AccountDAO;
import marauroa.server.game.db.AccountLinkDAO;
import marauroa.server.game.db.BanListDAO;
import marauroa.server.game.db.CharacterDAO;
import marauroa.server.game.db.GameEventDAO;
import marauroa.server.game.db.LoginEventDAO;
import marauroa.server.game.db.LoginSeedDAO;
import marauroa.server.game.db.RPObjectDAO;
import marauroa.server.game.db.RPZoneDAO;
import marauroa.server.game.db.StatisticsDAO;
import marauroa.server.game.rp.RPObjectFactory;

public class DAORegister {
    private final Map<Class<?>, Object> register = new HashMap();
    private RPObjectFactory factory;
    private static DAORegister instance;

    private DAORegister() {
    }

    public static DAORegister get() {
        if (instance == null) {
            DAORegister dAORegister = new DAORegister();
            dAORegister.registerDAOs();
            instance = dAORegister;
        }
        return instance;
    }

    public <T> void register(Class<T> clazz, T t) {
        this.register.put(clazz, t);
    }

    public <T> T get(Class<T> clazz) {
        T t = clazz.cast(this.register.get(clazz));
        if (t == null) {
            throw new IllegalArgumentException("No DAO registered for class " + clazz);
        }
        return t;
    }

    private void registerDAOs() {
        this.factory = RPObjectFactory.get();
        this.register(AccountDAO.class, new AccountDAO());
        this.register(AccountLinkDAO.class, new AccountLinkDAO());
        this.register(BanListDAO.class, new BanListDAO());
        this.register(CharacterDAO.class, new CharacterDAO());
        this.register(GameEventDAO.class, new GameEventDAO());
        this.register(LoginEventDAO.class, new LoginEventDAO());
        this.register(LoginSeedDAO.class, new LoginSeedDAO());
        this.register(RPObjectDAO.class, new RPObjectDAO(this.factory));
        this.register(RPZoneDAO.class, new RPZoneDAO(this.factory));
        this.register(StatisticsDAO.class, new StatisticsDAO());
    }

    public RPObjectFactory getRPObjectFactory() {
        return this.factory;
    }
}

