/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.db;

import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Properties;
import marauroa.common.Configuration;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.server.db.DBTransaction;
import marauroa.server.db.DatabaseConnectionException;
import marauroa.server.db.JDBCSQLHelper;
import marauroa.server.db.TransactionPool;
import marauroa.server.db.UpdateScript;
import marauroa.server.game.db.DAORegister;

public class DatabaseFactory {
    private static final Logger logger = Log4J.getLogger(DatabaseFactory.class);

    public void initializeTestDatabase() {
        Properties properties = new Properties();
        properties.put("jdbc_url", "jdbc:h2:mem:test;DB_CLOSE_DELAY=-1;AUTO_RECONNECT=TRUE");
        properties.put("jdbc_class", "org.h2.Driver");
        properties.put("database_adapter", "marauroa.server.db.adapter.H2DatabaseAdapter");
        this.internalInit(properties);
    }

    public void initializeDatabase() throws DatabaseConnectionException {
        try {
            this.internalInit(Configuration.getConfiguration().getAsProperties());
        }
        catch (IOException iOException) {
            logger.error("Failed to load configuration for database", iOException);
            throw new DatabaseConnectionException(iOException);
        }
    }

    private void internalInit(Properties properties) {
        try {
            if (TransactionPool.get() == null) {
                TransactionPool transactionPool = new TransactionPool(properties);
                transactionPool.registerGlobally();
                this.initializeDatabaseSchema();
                DAORegister.get();
                this.configureGameDatabaseAccess();
            }
        }
        catch (Exception exception) {
            logger.error("Failed to initialize database", exception);
            throw new DatabaseConnectionException(exception);
        }
    }

    private void initializeDatabaseSchema() {
        DBTransaction dBTransaction = TransactionPool.get().beginWork();
        try {
            new JDBCSQLHelper(dBTransaction).runDBScript("marauroa/server/marauroa_init.sql");
            new UpdateScript().update(dBTransaction);
            TransactionPool.get().commit(dBTransaction);
        }
        catch (SQLException sQLException) {
            logger.error(sQLException, sQLException);
            TransactionPool.get().rollback(dBTransaction);
        }
    }

    private void configureGameDatabaseAccess() {
        try {
            Configuration configuration = Configuration.getConfiguration();
            String string = configuration.get("database_implementation");
            if (string != null && !string.equals("marauroa.server.game.db.JDBCDatabase")) {
                Class<?> clazz = Class.forName(string);
                Method method = clazz.getDeclaredMethod("initialize", new Class[0]);
                method.invoke(clazz.newInstance(), new Object[0]);
            }
        }
        catch (Exception exception) {
            logger.error("error initializing game database", exception);
        }
    }
}

