/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.RPObject;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SLogout;
import marauroa.common.net.message.MessageS2CLogoutACK;
import marauroa.common.net.message.MessageS2CLogoutNACK;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.messagehandler.MessageHandler;
import marauroa.server.game.rp.DebugInterface;

class LogoutHandler
extends MessageHandler {
    private static final Logger logger = Log4J.getLogger(LogoutHandler.class);

    LogoutHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Message message) {
        MessageC2SLogout messageC2SLogout = (MessageC2SLogout)message;
        try {
            int n = messageC2SLogout.getClientID();
            PlayerEntry playerEntry = this.playerContainer.get(n);
            if (!this.isValidEvent(messageC2SLogout, playerEntry, ClientState.LOGIN_COMPLETE, ClientState.GAME_BEGIN)) {
                return;
            }
            RPObject rPObject = playerEntry.object;
            boolean bl = true;
            if (playerEntry.state == ClientState.GAME_BEGIN) {
                this.playerContainer.getLock().requestWriteLock();
                try {
                    int n2 = messageC2SLogout.getReason();
                    if (n2 > 0) {
                        DebugInterface.get().onCrash(rPObject);
                        return;
                    }
                    if (this.rpMan.onExit(rPObject)) {
                        playerEntry.storeRPObject(rPObject);
                    } else {
                        bl = false;
                    }
                }
                finally {
                    this.playerContainer.getLock().releaseLock();
                }
            }
            if (bl) {
                this.stats.add("Players logout", 1);
                logger.info("Logging out correctly channel: " + playerEntry.getInetSocketAddress());
                this.playerContainer.remove(n);
                MessageS2CLogoutACK messageS2CLogoutACK = new MessageS2CLogoutACK(messageC2SLogout.getChannel());
                messageS2CLogoutACK.setClientID(n);
                messageS2CLogoutACK.setProtocolVersion(messageC2SLogout.getProtocolVersion());
                this.netMan.sendMessage(messageS2CLogoutACK);
                playerEntry.state = ClientState.LOGOUT_ACCEPTED;
            } else {
                MessageS2CLogoutNACK messageS2CLogoutNACK = new MessageS2CLogoutNACK(messageC2SLogout.getChannel());
                messageS2CLogoutNACK.setClientID(n);
                messageS2CLogoutNACK.setProtocolVersion(messageC2SLogout.getProtocolVersion());
                this.netMan.sendMessage(messageS2CLogoutNACK);
            }
        }
        catch (Exception exception) {
            logger.error("error while processing LogoutEvent", exception);
        }
    }
}

