/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.messagehandler;

import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.net.message.Message;
import marauroa.common.net.message.MessageC2SOutOfSync;
import marauroa.server.game.container.ClientState;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.messagehandler.MessageHandler;

class OutOfSyncHandler
extends MessageHandler {
    private static final Logger logger = Log4J.getLogger(OutOfSyncHandler.class);

    OutOfSyncHandler() {
    }

    @Override
    public void process(Message message) {
        MessageC2SOutOfSync messageC2SOutOfSync = (MessageC2SOutOfSync)message;
        try {
            int n = messageC2SOutOfSync.getClientID();
            PlayerEntry playerEntry = this.playerContainer.get(n);
            if (!this.isValidEvent(messageC2SOutOfSync, playerEntry, ClientState.GAME_BEGIN)) {
                return;
            }
            playerEntry.requestSync();
        }
        catch (Exception exception) {
            logger.error("error while processing OutOfSyncEvent", exception);
        }
    }
}

