/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.game.rp;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import marauroa.common.Log4J;
import marauroa.common.Logger;
import marauroa.common.game.IRPZone;
import marauroa.common.game.RPObject;
import marauroa.common.game.RPObjectInvalidException;
import marauroa.server.game.container.PlayerEntry;
import marauroa.server.game.container.PlayerEntryContainer;
import marauroa.server.game.rp.MarauroaRPZone;

public class RPWorld
implements Iterable<IRPZone> {
    private static final Logger logger = Log4J.getLogger(RPWorld.class);
    private static RPWorld instance;
    Map<IRPZone.ID, IRPZone> zones = new ConcurrentHashMap<IRPZone.ID, IRPZone>();
    PlayerEntryContainer playerContainer;
    IRPZone defaultZone;

    protected RPWorld() {
    }

    protected void initialize() {
        this.playerContainer = PlayerEntryContainer.getContainer();
    }

    static void set(RPWorld rPWorld) {
        instance = rPWorld;
    }

    public static RPWorld get() {
        if (instance == null) {
            RPWorld rPWorld = new RPWorld();
            rPWorld.initialize();
            instance = rPWorld;
        }
        return instance;
    }

    public void onInit() {
    }

    public void onFinish() {
        for (IRPZone iRPZone : this.zones.values()) {
            try {
                iRPZone.onFinish();
            }
            catch (Exception exception) {
                logger.warn("Exception at onFinish", exception);
            }
        }
    }

    public void addRPZone(IRPZone iRPZone) {
        this.zones.put(iRPZone.getID(), iRPZone);
    }

    public IRPZone getDefaultZone() {
        if (this.defaultZone != null) {
            return this.defaultZone;
        }
        if (this.zones.isEmpty()) {
            MarauroaRPZone marauroaRPZone = new MarauroaRPZone("lobby");
            this.addRPZone(marauroaRPZone);
        }
        return this.zones.values().iterator().next();
    }

    public void setDefaultZone(IRPZone iRPZone) {
        this.defaultZone = iRPZone;
    }

    public boolean hasRPZone(IRPZone.ID iD) {
        return this.zones.containsKey(iD);
    }

    public IRPZone getRPZone(IRPZone.ID iD) {
        return this.zones.get(iD);
    }

    public IRPZone getRPZone(RPObject.ID iD) {
        return this.zones.get(new IRPZone.ID(iD.getZoneID()));
    }

    public IRPZone removeRPZone(IRPZone.ID iD) throws Exception {
        IRPZone iRPZone = this.zones.remove(iD);
        if (iRPZone != null) {
            iRPZone.onFinish();
        }
        return iRPZone;
    }

    public IRPZone removeRPZone(RPObject.ID iD) throws Exception {
        IRPZone.ID iD2 = new IRPZone.ID(iD.getZoneID());
        IRPZone iRPZone = this.zones.remove(iD2);
        if (iRPZone != null) {
            iRPZone.onFinish();
        }
        return iRPZone;
    }

    public void add(RPObject rPObject) {
        String string = rPObject.get("zoneid");
        if (string != null) {
            IRPZone iRPZone = this.zones.get(new IRPZone.ID(string));
            if (iRPZone == null) {
                logger.error("Unknown zone: " + string);
                return;
            }
            iRPZone.assignRPObjectID(rPObject);
            iRPZone.add(rPObject);
        }
    }

    public void requestSync(RPObject rPObject) {
        PlayerEntry playerEntry = this.playerContainer.get(rPObject);
        if (playerEntry != null) {
            playerEntry.requestSync();
        }
    }

    public RPObject get(RPObject.ID iD) {
        IRPZone iRPZone = this.zones.get(new IRPZone.ID(iD.getZoneID()));
        return iRPZone.get(iD);
    }

    public boolean has(RPObject.ID iD) {
        IRPZone iRPZone = this.zones.get(new IRPZone.ID(iD.getZoneID()));
        return iRPZone.has(iD);
    }

    public RPObject remove(RPObject.ID iD) {
        IRPZone iRPZone = this.zones.get(new IRPZone.ID(iD.getZoneID()));
        if (iRPZone != null) {
            return iRPZone.remove(iD);
        }
        logger.error("Cannot remove rpobject with id " + iD + " from zone because there is no zone with that name in the RPWorld");
        return null;
    }

    @Override
    public Iterator<IRPZone> iterator() {
        return this.zones.values().iterator();
    }

    public void modify(RPObject rPObject) {
        IRPZone iRPZone = this.zones.get(new IRPZone.ID(rPObject.get("zoneid")));
        if (iRPZone != null) {
            iRPZone.modify(rPObject);
        } else {
            logger.warn("calling RPWorld.modify on a zoneless object: " + rPObject + " parent: " + rPObject.getContainerBaseOwner(), new Throwable());
        }
    }

    public void changeZone(IRPZone.ID iD, RPObject rPObject) {
        try {
            String string = iD.getID();
            if (string.equals(rPObject.get("zoneid"))) {
                return;
            }
            this.remove(rPObject.getID());
            rPObject.put("zoneid", string);
            this.add(rPObject);
            this.requestSync(rPObject);
        }
        catch (Exception exception) {
            logger.error("error changing Zone", exception);
            throw new RPObjectInvalidException("zoneid");
        }
    }

    public void changeZone(String string, RPObject rPObject) {
        this.changeZone(new IRPZone.ID(string), rPObject);
    }

    public void nextTurn() {
        for (IRPZone iRPZone : this.zones.values()) {
            iRPZone.nextTurn();
        }
    }

    public int size() {
        long l = 0L;
        for (IRPZone iRPZone : this.zones.values()) {
            l += iRPZone.size();
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }
}

