/*
 * Decompiled with CFR 0.152.
 */
package marauroa.server.net.web;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import marauroa.common.Configuration;
import marauroa.server.game.rp.DebugInterface;
import marauroa.server.game.rp.RPServerManager;

public class WebServletForStaticContent
extends HttpServlet {
    private static final long serialVersionUID = 3182173716768800221L;
    private final RPServerManager rpMan;

    public WebServletForStaticContent(RPServerManager rPServerManager) {
        this.rpMan = rPServerManager;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String string = httpServletRequest.getPathInfo();
        string = string.substring(httpServletRequest.getContextPath().length());
        String string2 = this.guessContentType(string);
        httpServletResponse.setContentType(string2);
        Configuration configuration = Configuration.getConfiguration();
        if (configuration.has("debug_fake_web_username")) {
            httpServletRequest.getSession().setAttribute("marauroa_authenticated_username", (Object)configuration.get("debug_fake_web_username"));
        }
        String string3 = "default-src 'none'; script-src 'self'; connect-src 'self' ws://*:* wss://*:*; img-src * data: blob: filesystem:; media-src * data: blob: filesystem:; style-src 'self'; font-src 'self'; frame-ancestors 'none'; sandbox allow-forms allow-same-origin allow-scripts allow-popups allow-modals allow-orientation-lock allow-pointer-lock allow-presentation allow-top-navigation allow-downloads";
        if (configuration.has("content_security_policy")) {
            string3 = configuration.get("content_security_policy");
        }
        httpServletResponse.setHeader("Content-Security-Policy", string3);
        if (string.endsWith(".css") || string.endsWith(".html") || string.endsWith(".js") || string.endsWith(".json")) {
            httpServletResponse.setHeader("Cache-Control", "no-store, must-revalidate");
        }
        this.sendFile(httpServletRequest, httpServletResponse, string);
    }

    private String guessContentType(String string) {
        String string2 = null;
        if (string.endsWith("js")) {
            string2 = "text/javascript";
        } else if (string.endsWith("json")) {
            string2 = "application/json";
        } else if (string.endsWith(".html")) {
            string2 = "text/html";
        } else if (string.endsWith(".css")) {
            string2 = "text/css";
        } else if (string.endsWith(".xml")) {
            string2 = "text/xml";
        } else {
            string2 = this.rpMan.getMimeTypeForResource(string);
            if (string2 == null) {
                string2 = "application/octet-stream";
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        String string2 = string;
        if (string2.indexOf("..") > -1) {
            throw new FileNotFoundException(string2);
        }
        if (string2.startsWith("/marauroa/")) {
            string2 = string2.substring(9);
        }
        if (string2.startsWith("/srcjs/")) {
            string2 = string2.substring(6);
        }
        if (string2.startsWith("/src/js/")) {
            string2 = string2.substring(7);
        }
        if (string2.startsWith("/build/js/")) {
            string2 = string2.substring(9);
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = WebServletForStaticContent.class.getClassLoader().getResourceAsStream("js" + string2);
            if (inputStream == null) {
                inputStream = WebServletForStaticContent.class.getClassLoader().getResourceAsStream("srcjs" + string2);
            }
            if (inputStream == null) {
                inputStream = WebServletForStaticContent.class.getClassLoader().getResourceAsStream("src/js" + string2);
            }
            if (inputStream == null) {
                inputStream = DebugInterface.get().onFileRequest(httpServletRequest, httpServletResponse, string2);
            }
            if (inputStream == null) {
                inputStream = this.rpMan.getResource(string2);
            }
            if (inputStream == null) {
                httpServletResponse.setStatus(404);
                throw new FileNotFoundException(string2);
            }
            outputStream = httpServletResponse.getOutputStream();
            byte[] byArray = new byte[8192];
            int n = inputStream.read(byArray);
            while (n > -1) {
                outputStream.write(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}

