/*
 * Decompiled with CFR 0.152.
 */
package marauroa.tools.protocolanalyser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.List;
import marauroa.common.Log4J;
import marauroa.common.Utility;
import marauroa.common.net.Channel;
import marauroa.common.net.Decoder;
import marauroa.common.net.InvalidVersionException;
import marauroa.common.net.message.Message;

public class ProtocolAnalyser {
    private final Decoder decoder = Decoder.get();

    public void dump(InputStream inputStream, boolean bl) throws IOException, InvalidVersionException {
        byte[] byArray;
        int n;
        InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved("127.0.0.1", 12345);
        Channel channel = new Channel(null, inetSocketAddress, null);
        do {
            List<Message> list;
            byArray = new byte[100];
            n = inputStream.read(byArray);
            if (bl) {
                System.out.println(Utility.dumpByteArray(byArray));
            }
            if ((list = this.decoder.decode(channel, byArray)) == null && !bl) continue;
            if (list != null) {
                for (Message message : list) {
                    System.out.println("version: " + message.getProtocolVersion());
                    System.out.println(message);
                }
            }
            System.out.println();
        } while (n >= byArray.length);
    }

    public static void main(String[] stringArray) throws IOException, InvalidVersionException {
        Log4J.init();
        boolean bl = true;
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.out.println("java " + ProtocolAnalyser.class.getName() + " <filename> [<boolean__dump_raw_data>]");
            return;
        }
        if (stringArray.length == 2) {
            bl = Boolean.parseBoolean(stringArray[1]);
        }
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        new ProtocolAnalyser().dump(fileInputStream, bl);
        ((InputStream)fileInputStream).close();
    }
}

